﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Magazyny" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>Podsumowanie marży</title>
		<meta content="C#" name="CODE_LANGUAGE" />
		<meta content="JavaScript" name="vs_defaultClientScript" />
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
		<script runat="server">

			public class ParametryContext : ContextBase
			{
				private bool _ignorujZaliczkowe = false;
                
				public ParametryContext(Context cx)
					: base(cx)
				{}

				[Soneta.Tools.Priority(10)]
				public bool IgnorujZaliczkowe
				{
					get 
					{ 
						return this._ignorujZaliczkowe;
					}
					set
					{
						this._ignorujZaliczkowe = value;
						OnChanged(EventArgs.Empty);
					}
				}
                
                [Soneta.Tools.Priority(20)]
                public bool IgnorujDuplikaty {
                    get {
						return true;
                    }
                }
			}

			ParametryContext parametry;

			[Context]
			public ParametryContext Parametry
			{
				get 
				{ 
					return parametry; 
				}
				set 
				{ 
					parametry = value; 
				}
			}
            Row[] rows;
void dc_ContextLoad(object sender, EventArgs args) {
    rows = (Row[])dc[typeof(Row[])];
    
    ListWithView lwv = new ListWithView(rows, HandelModule.GetInstance(dc.Session).DokHandlowe.WgDaty);

	sIgnorujZaliczkowe.Visible = Parametry.IgnorujZaliczkowe;


	var kwpz = this.LoadKWPZ();
	
	decimal zak = 0, zakT = 0, zakP = 0;
	decimal sp = 0, spT = 0, spP = 0, spU = 0;
	decimal marza = 0, marzaT = 0, marzaP = 0;
	
	ObrotyDokumentuWorker w = new ObrotyDokumentuWorker();
	w.IgnorujZaliczkowe = this.Parametry.IgnorujZaliczkowe;

	foreach (DokumentHandlowy dok in lwv) {        
		if (dok.Anulowany) continue;
		if (this.Parametry.IgnorujDuplikaty && dok.Definicja.DuplikatWartosci) continue;
		System.Diagnostics.Trace.Write(dok, "Progress");
		w.Dokument = dok;
		
		zak += w.WartośćZakupu;
		zakT += w.WartośćZakupuTowarów;
		zakP += w.WartośćZakupuProduktów;
		
		sp += w.WartośćSprzedaży;
		spT += w.WartośćSprzedażyTowarów;
		spP += w.WartośćSprzedażyProduktów;
		spU += w.WartośćSprzedażyUsług;
		
		marza += w.Marża;
		marzaT += w.MarżaTowarów;
		marzaP += w.MarżaProduktów;
	}
	
	foreach (DokumentHandlowy dok in kwpz) {        
		w.Dokument = dok;
		
		zak += w.WartośćZakupu;
		zakT += w.WartośćZakupuTowarów;
		zakP += w.WartośćZakupuProduktów;

		marza = sp - zak;
		marzaT = spT - zakT;
		marzaP = spP - zakP;
	}

	LabelZ.EditValue = zak;
	LabelZT.EditValue = zakT;
	LabelZP.EditValue = zakP;

	LabelS.EditValue = sp;
	LabelST.EditValue = spT;
	LabelSP.EditValue = spP;
	LabelSU.EditValue = spU;

	LabelM.EditValue = marza;
	LabelMT.EditValue = marzaT;
	LabelMP.EditValue = marzaP;
	LabelMU.EditValue = spU;
}
			
			private Soneta.Business.View LoadKWPZ()
			{
				HandelModule hm = HandelModule.GetInstance(dc);

				SubTable st;

				Magazyn magazyn = (Magazyn)dc[typeof(Magazyn)];
				if (magazyn == null)
					st = hm.DokHandlowe.WgDaty;
				else
					st = hm.DokHandlowe.WgMagazyn[magazyn];

				Soneta.Handel.Forms.DokHandloweViewInfo.WParams pars = (Soneta.Handel.Forms.DokHandloweViewInfo.WParams)
					dc[typeof(Soneta.Handel.Forms.DokHandloweViewInfo.WParams)];
				st = new SubTable(st, pars.Okres);

			Soneta.Business.View vwk = st.CreateView();
				vwk.Condition &= new FieldCondition.Equal("Definicja", hm.DefDokHandlowych.KorektaPZWZ);
				vwk.FilterCondition += GridKor_BeforeRow;
				return vwk;
			}
			
			void GridKor_BeforeRow(object sender, ConditionEventArgs args)
			{
				DokumentHandlowy dok = (DokumentHandlowy)args.Row;
				if (!testDok(dok))
					args.Accepted = false;
			}

            bool testDok(DokumentHandlowy dok) {
                foreach (DokumentHandlowy wz in dok.Nadrzędne)
                {
                    if (wz.Definicja == dok.Module.DefDokHandlowych.KorektaPZWZ)
                    {
                        if (testDok(wz)) return true;
                    }
                    else if (wz.KierunekMagazynu == KierunekPartii.Rozchód)
                    {
                        if (JestHandlowy(wz) || MaHandlowe(wz)) return true;
                    }
                }
                return false;
            }
            private bool MaHandlowe(DokumentHandlowy dok) {
                foreach (DokumentHandlowy d in dok.DokumentyHandlowe)
                {
                    return true;
                }
                return false;
            }

            private bool JestHandlowy(DokumentHandlowy dok) {
                bool res = KategoriaHandlowa.HandelPierwszy <= dok.Kategoria && dok.Kategoria <= KategoriaHandlowa.HandelOstatni;
                if (res)
                {
                    res = false;
                    foreach (Row r in rows)
                        if (r == dok)
                        {
                            res = true;
                            break;
                        }
                }
                return res;
            }			
		</script>
	</head>
	<body>
		<form method="post" runat="server" action="#">
							<ea:datacontext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:datacontext>
				<eb:reportheader id="ReportHeader" title="Podsumowanie marży|</STRONG>Okres:<STRONG> {2}|</STRONG>Magazyn:<STRONG> {3}</STRONG>"
					runat="server" DataMember3="DokHandloweViewInfo+WParams.Magazyn" DataMember2="DokHandloweViewInfo+WParams.Okres"></eb:reportheader>
		<font face="Verdana" size="2">Raport nie uwzględnia duplikatów.</font>
		<br />
		<ea:Section runat="server" ID="sIgnorujZaliczkowe">
			<font face="Verdana" size="2">Raport nie uwzględnia faktur zaliczkowych.</font>
			<br />
        </ea:Section>
        <font face="Verdana" size="2">Raport uwzględnia korekty kosztu (KWPZ).</font>
        <br />
		</ea:Section>
				<table id="Table1" style="BORDER-TOP-WIDTH: 1px; BORDER-LEFT-WIDTH: 1px; FONT-SIZE: 12pt; BORDER-LEFT-COLOR: silver; BORDER-BOTTOM-WIDTH: 1px; BORDER-BOTTOM-COLOR: silver; BORDER-TOP-COLOR: silver; FONT-FAMILY: Arial; BORDER-COLLAPSE: collapse; BORDER-RIGHT-WIDTH: 1px; BORDER-RIGHT-COLOR: silver"
					cellspacing="1" cellpadding="1" border="1">
					<tr>
						<td style="WIDTH: 217px; border-color: Gray;" align="center">Opis</td>
						<td style="WIDTH: 128px; border-color: Gray;" align="center">Wartość&nbsp;w cenach 
							zakupu</td>
						<td style="WIDTH: 128px; border-color: Gray;" align="center">
							Wartość sprzedaży</td>
						<td style="WIDTH: 128px; border-color: Gray;" align="center">Marża</td>
					</tr>
					<tr>
						<td style="WIDTH: 217px; border-color: Gray;" width="300">towary</td>
						<td style="WIDTH: 128px; border-color: Gray;" align="right">
							<ea:DataLabel id="LabelZT" runat="server" Format="{0:n}" Bold="False"></ea:DataLabel></td>
						<td style="WIDTH: 128px; border-color: Gray;" align="right">
							<ea:DataLabel id="LabelST" runat="server" Format="{0:n}" Bold="False"></ea:DataLabel></td>
						<td style="WIDTH: 128px; border-color: Gray;" align="right">
							<ea:DataLabel id="LabelMT" runat="server" Format="{0:n}" Bold="False"></ea:DataLabel></td>
					</tr>
					<tr>
						<td style="WIDTH: 217px; border-color: Gray;" width="300">produkty</td>
						<td style="WIDTH: 128px; border-color: Gray;" align="right">
							<ea:DataLabel id="LabelZP" runat="server" Format="{0:n}" Bold="False"></ea:DataLabel></td>
						<td style="WIDTH: 128px; border-color: Gray;" align="right">
							<ea:DataLabel id="LabelSP" runat="server" Format="{0:n}" Bold="False"></ea:DataLabel></td>
						<td style="WIDTH: 128px; border-color: Gray;" align="right">
							<ea:DataLabel id="LabelMP" runat="server" Format="{0:n}" Bold="False"></ea:DataLabel></td>
					</tr>
					<tr>
						<td style="WIDTH: 217px; HEIGHT: 21px; border-color: Gray;" >usługi</td>
						<td style="WIDTH: 128px; HEIGHT: 21px; border-color: Gray;" align="right"></td>
						<td style="WIDTH: 128px; HEIGHT: 21px; border-color: Gray;" align="right">
							<ea:DataLabel id="LabelSU" runat="server" Format="{0:n}" Bold="False"></ea:DataLabel></td>
						<td style="WIDTH: 128px; HEIGHT: 21px; border-color: Gray;" align="right">
							<ea:DataLabel id="LabelMU" runat="server" Format="{0:n}" Bold="False"></ea:DataLabel></td>
					</tr>
					<tr>
						<td style="WIDTH: 217px; border-color: Gray;" ><strong>RAZEM</strong></td>
						<td style="WIDTH: 128px; border-color: Gray;" align="right">
							<ea:DataLabel id="LabelZ" runat="server" Format="{0:n}"></ea:DataLabel></td>
						<td style="WIDTH: 128px; border-color: Gray;" align="right">
							<ea:DataLabel id="LabelS" runat="server" Format="{0:n}"></ea:DataLabel></td>
						<td style="WIDTH: 128px; border-color: Gray;" align="right">
							<ea:DataLabel id="LabelM" runat="server" Format="{0:n}"></ea:DataLabel></td>
					</tr>
				</table>
				<eb:reportfooter id="ReportFooter" runat="server" TheEnd="False"></eb:reportfooter>
		</form>
	</body>
</html>

